/*
 * Decompiled with CFR 0.152.
 */
package utility;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.SystemClock;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class DateUtil {
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    private static SimpleDateFormat a;

    public static long getCurrentTime() {
        try {
            return SystemClock.elapsedRealtime();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return System.currentTimeMillis();
        }
    }

    public static String getCurrentTime(String string) {
        return new SimpleDateFormat(string).format(new Date(DateUtil.getCurrentTime()));
    }

    public static long getCurrentDate(Context object) {
        object = DateUtil.getCurrentTime(DATE_FORMAT);
        try {
            return new SimpleDateFormat(DATE_FORMAT).parse((String)object).getTime();
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
            return new Date().getTime();
        }
    }

    public static Date getYearFirst(int n) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, n);
        return calendar.getTime();
    }

    public static Date getYearLast(int n) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, n);
        calendar.roll(6, -1);
        return calendar.getTime();
    }

    public static int getWeekOfYear(Date date) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setFirstDayOfWeek(2);
        gregorianCalendar.setMinimalDaysInFirstWeek(7);
        gregorianCalendar.setTime(date);
        return gregorianCalendar.get(3);
    }

    public static int getMaxWeekNumOfYear(int n) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(n, 11, 31, 23, 59, 59);
        return DateUtil.getWeekOfYear(gregorianCalendar.getTime());
    }

    public static Date getFirstDayOfWeek(int n, int n2) {
        GregorianCalendar gregorianCalendar = (GregorianCalendar)DateUtil.getFirstDayOfWeek(n).clone();
        ((Calendar)gregorianCalendar).add(5, n2 * 7);
        return DateUtil.getFirstDayOfWeek(gregorianCalendar.getTime());
    }

    public static Date getLastDayOfWeek(int n, int n2) {
        GregorianCalendar gregorianCalendar = (GregorianCalendar)DateUtil.getFirstDayOfWeek(n).clone();
        ((Calendar)gregorianCalendar).add(5, n2 * 7);
        return DateUtil.getLastDayOfWeek(gregorianCalendar.getTime());
    }

    public static Calendar getFirstDayOfWeek(int n) {
        GregorianCalendar gregorianCalendar;
        GregorianCalendar gregorianCalendar2 = gregorianCalendar;
        new GregorianCalendar().set(n, 0, 1, 0, 0, 0);
        n = gregorianCalendar2.get(7);
        if (n == 6 || n == 7 || n == 1) {
            while (gregorianCalendar2.get(7) != 2) {
                ((Calendar)gregorianCalendar2).add(6, 1);
            }
        }
        return gregorianCalendar2;
    }

    public static Date getFirstDayOfWeek(Date date) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setFirstDayOfWeek(2);
        gregorianCalendar.setTime(date);
        gregorianCalendar.set(7, gregorianCalendar.getFirstDayOfWeek());
        return gregorianCalendar.getTime();
    }

    @SuppressLint(value={"WrongConstant"})
    public static Date getLastDayOfWeek(Date date) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setFirstDayOfWeek(2);
        gregorianCalendar.setTime(date);
        gregorianCalendar.set(7, gregorianCalendar.getFirstDayOfWeek() + 6);
        return gregorianCalendar.getTime();
    }

    public static boolean isLastDayInYearLastWeek(Date date) {
        boolean bl = false;
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        int n = gregorianCalendar.get(7);
        if (n == 5 || n == 6 || n == 7 || n == 1) {
            bl = true;
        }
        return bl;
    }

    public static Date getLastDayOfYear(int n) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(n, 11, 31, 0, 0, 0);
        return gregorianCalendar.getTime();
    }

    public static boolean isEffectiveDate(Date comparable, Date date, Date date2) {
        if (Math.abs(comparable.getTime() - date.getTime()) >= 1000L && Math.abs(comparable.getTime() - date2.getTime()) >= 1000L) {
            GregorianCalendar gregorianCalendar;
            GregorianCalendar gregorianCalendar2;
            GregorianCalendar gregorianCalendar3 = gregorianCalendar2;
            gregorianCalendar3();
            gregorianCalendar2.setTime((Date)comparable);
            GregorianCalendar gregorianCalendar4 = new GregorianCalendar();
            gregorianCalendar4.setTime(date);
            comparable = gregorianCalendar;
            ((GregorianCalendar)comparable)();
            gregorianCalendar.setTime(date2);
            return gregorianCalendar2.after(gregorianCalendar4) && gregorianCalendar3.before(comparable);
        }
        return true;
    }

    public static String[] getWeekStartAndEndDay(Date date) {
        String[] stringArray = new String[2];
        Date date2 = date;
        date = DateUtil.getFirstDayOfWeek(date2);
        Date date3 = DateUtil.getLastDayOfWeek(date2);
        stringArray[0] = a.format(date.getTime());
        stringArray[1] = a.format(date3.getTime());
        return stringArray;
    }

    static {
        new SimpleDateFormat("MM/dd");
        a = new SimpleDateFormat("yyyy/MM/dd");
    }
}

